//
// Created by marvin on 9/13/18.
//

#ifndef FAST_DOWNWARD_SEARCHSTATISTICSEXPANDED_H
#define FAST_DOWNWARD_SEARCHSTATISTICSEXPANDED_H


class SearchStatisticsExpanded {
    int pruned_states;
    int real_goal_states; //Number of goal states expanded from the artificial.
    int dead_goal_states; // Number of dead end goal states.
    int frontier_meetings; //Number of times the frontiers meet.
    //Number of expansions before the frontiers meet for the first time.
    int expansions_before_first_meeting;

public:
    SearchStatisticsExpanded();
    ~SearchStatisticsExpanded() = default;

    // Methods that update statistics.
    void inc_pruned(int inc = 1) {pruned_states += inc;}
    void inc_real_goal_states(int inc = 1) {real_goal_states += inc;}
    void inc_frontier_meetings(int inc = 1) {frontier_meetings += inc;}
    void inc_dead_goal_states(int inc = 1) {dead_goal_states += inc;}

    void set_expansions_before_first_meeting(int val);


    // Methods that access statistics.
    int get_pruned() const {return pruned_states;}
    int get_real_goal_states() const {return real_goal_states;}
    int get_frontier_meetings() const {return frontier_meetings;}
    int get_expansions_before_first_meeting() const {return expansions_before_first_meeting;};
    int get_dead_goal_states() const {return dead_goal_states;}
};


#endif //FAST_DOWNWARD_SEARCHSTATISTICSEXPANDED_H
